#include <GL/glut.h>
#include <stdlib.h>
#include <time.h>

#define GOMBOKSZAMA 1000

float fvGombPos[GOMBOKSZAMA][3];

float fHajoZ = -500.0f;
float fHajoY = 0.0f;

void display(void)
	{
   glClearColor (0.0, 0.0, 0.0, 0.0);
   glClear (GL_COLOR_BUFFER_BIT);
   glColor3f (1.0, 1.0, 1.0);
   glLoadIdentity ();             // egysgmtrix
   //
	// nzpont transzformci viewing transformation 
	// 
   glRotatef(fHajoY, 0.0f, 1.0f, 0.0f); 
	glTranslatef(-150.0,-150.0, fHajoZ);
	//
	// model transformacio
	//
	for(int i = 0;   i < GOMBOKSZAMA; i++ )
		{
/*		glPushMatrix();
		glTranslatef(fvGombPos[i][0],fvGombPos[i][1],fvGombPos[i][2]);
		glutWireSphere(2.0f, 10, 10); 
		glPopMatrix();*/
		
		glTranslatef(fvGombPos[i][0],fvGombPos[i][1],fvGombPos[i][2]);
		glutWireSphere(2.0f, 10, 10); 
		glTranslatef(-fvGombPos[i][0],-fvGombPos[i][1],-fvGombPos[i][2]);
		}
	glutSwapBuffers();
	}
//
// viewport, projekci, s transformci
//
void reshape (int w, int h)
	{
   glViewport (0, 0, w, h); 
   glMatrixMode (GL_PROJECTION);
   glLoadIdentity ();
	gluPerspective (60.0, 1.0, 10.0, 1000.0);
	glMatrixMode (GL_MODELVIEW);
	}
//
// random gombhelyzetek generlsa
//
void gombinit()
	{
   srand( (unsigned)time( NULL ) );
	
   for(int i = 0;   i < GOMBOKSZAMA; i++ )
		{
		fvGombPos[i][0] = (float) rand() / 100.0f;
		fvGombPos[i][1] = (float) rand() / 100.0f;
		fvGombPos[i][2] = (float) rand() / 100.0f;
		}
	}

void keyboard(unsigned char key, int x, int y)
	{
   switch (key) 
		{
      case 'w':
			fHajoZ += 10.0f;
      break;
		case 's':
			fHajoZ -= 10.0f;
      break;
      case 'a':
			fHajoY--;
      break;
		case 'd':
			fHajoY++;
      break;
		}
	glutPostRedisplay();	
	}

int main()
	{
   glutInitDisplayMode (GLUT_DOUBLE | GLUT_RGB);
   glutInitWindowSize (500, 500); 
   glutCreateWindow ("Teglatest Rajzolasa");
   glutDisplayFunc(display); 
	gombinit();
   glutReshapeFunc(reshape);
	glutKeyboardFunc(keyboard);
   glutMainLoop();
   return 0;
	}